/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.util.UtilParticle;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class CandleWaterBlock
extends BlockCyclic {
    public static ForgeConfigSpec.IntValue TICK_RATE;
    public static ForgeConfigSpec.IntValue RADIUS;
    private MobCategory type = MobCategory.MONSTER;
    private static final double BOUNDS = 3.0;
    private static final VoxelShape AABB;
    private static final double CHANCE_SOUND = 0.3;

    public CandleWaterBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.8f).m_60955_().m_60977_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        boolean old = (Boolean)state.m_61143_((Property)LIT);
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!old)));
        UtilSound.playSound(world, pos, old ? SoundEvents.f_11937_ : SoundEvents.f_11936_);
        UtilParticle.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123769_, pos.m_7494_(), 12);
        return InteractionResult.SUCCESS;
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue() && rand.nextDouble() < 0.3) {
            UtilSound.playSound(worldIn, pos, SoundEvents.f_11936_);
        }
        super.m_7100_(stateIn, worldIn, pos, rand);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        this.triggerUpdate((Level)worldIn, pos, rand);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        this.triggerUpdate((Level)worldIn, pos, random);
    }

    private void triggerUpdate(Level world, BlockPos pos, Random rand) {
        try {
            if (!world.f_46443_ && ((Boolean)world.m_8055_(pos).m_61143_((Property)LIT)).booleanValue()) {
                this.trySpawn(world, pos, rand);
            }
        }
        catch (Exception exception) {
            ModCyclic.LOGGER.error("Error spawning monster ", exception);
        }
    }

    private void trySpawn(Level world, BlockPos pos, Random rand) throws Exception {
        float z;
        float y;
        float x = pos.m_123341_() + Mth.m_14072_((Random)rand, (int)(-1 * (Integer)RADIUS.get()), (int)((Integer)RADIUS.get()));
        BlockPos posTarget = new BlockPos((double)x, (double)(y = (float)pos.m_123342_()), (double)(z = (float)(pos.m_123343_() + Mth.m_14072_((Random)rand, (int)(-1 * (Integer)RADIUS.get()), (int)((Integer)RADIUS.get())))));
        Mob monster = this.findMonsterToSpawn(world, posTarget, rand);
        if (monster == null || !world.m_46859_(posTarget)) {
            return;
        }
        monster.m_7678_((double)x, (double)y, (double)z, world.f_46441_.nextFloat() * 360.0f, 0.0f);
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((Mob)monster, (LevelAccessor)world, (double)x, (double)y, (double)z, null, (MobSpawnType)MobSpawnType.SPAWNER);
        if (canSpawn == Event.Result.DENY || !monster.m_5545_((LevelAccessor)world, MobSpawnType.SPAWNER)) {
            this.afterSpawnFailure(world, pos);
        } else if (world.m_7967_((Entity)monster)) {
            this.afterSpawnSuccess(monster, world, pos, rand);
        }
    }

    private void afterSpawnFailure(Level world, BlockPos pos) {
        world.m_186460_(pos, (Block)this, ((Integer)TICK_RATE.get()).intValue());
    }

    private void afterSpawnSuccess(Mob monster, Level world, BlockPos pos, Random rand) {
        monster.m_6518_((ServerLevelAccessor)world.m_142572_().m_129880_(world.m_46472_()), world.m_6436_(pos), MobSpawnType.SPAWNER, null, null);
        world.m_186460_(pos, (Block)this, ((Integer)TICK_RATE.get()).intValue());
    }

    private Mob findMonsterToSpawn(Level world, BlockPos pos, Random rand) {
        WeightedRandomList spawners = ((Biome)world.m_204166_(pos).m_203334_()).m_47518_().m_151798_(this.type);
        if (spawners.m_146337_()) {
            return null;
        }
        MobSpawnSettings.SpawnerData spawner = spawners.m_146335_(rand).orElse(null);
        if (spawner == null) {
            return null;
        }
        Mob monster = null;
        Entity ent = spawner.f_48404_.m_20615_(world);
        if (ent instanceof Mob) {
            monster = (Mob)ent;
        }
        return monster;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    static {
        AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    }
}

